<?php

namespace Import\ApiBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Import\ApiBundle\Entity\GpwIndex;
use Import\ApiBundle\Entity\GpwSession;
use Import\ApiBundle\Entity\SessionCurrency;
use Import\ApiBundle\Entity\SessionNewConnect;

/**
 * GpwSessionRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class GpwSessionRepository extends EntityRepository
{
    /**
     * create new SessionCurrency
     *
     * @param GpwIndex $GpwIndex
     * @param $data
     * @return GpwSession
     */
    public function add(GpwIndex $GpwIndex, $data)
    {
        $GpwSession = $this->findOneBy(array('date'=>new \DateTime($data['Date']),'indexId'=>$GpwIndex->getId()));
        if(empty($GpwSession))
        {
            $GpwSession = new GpwSession();
        }
        $GpwSession->setDate(new \DateTime($data['Date']));
        $GpwSession->setOpen(isset($data['Open']) ? $data['Open'] : '');
        $GpwSession->setHigh(isset($data['High']) ? $data['High'] : '');
        $GpwSession->setLow(isset($data['Low']) ? $data['Low'] : '');
        $GpwSession->setClose(isset($data['Close']) ? $data['Close'] : '');
        $GpwSession->setVolume(isset($data['Volume']) ? $data['Volume'] : '');
        $GpwSession->setOi(isset($data['Oi']) ? $data['Oi'] : '');

        $this->getEntityManager()->persist($GpwSession);

        return $GpwSession;
    }

    public function getActualSessions()
    {
        $QueryBuilder = $this->createQueryBuilder('s');
        $QueryBuilder
            ->leftJoin('s.index','i')
            ->leftJoin('i.type','t')
            ->select('s,MAX(s.date) as maxDate','i','t')
            ->groupBy('i.id')
            ->having('maxDate = s.date')
        ;

        return $QueryBuilder->getQuery()->getArrayResult();
    }

    /**
     * @param $indexSymbol
     * @return GpwSession
     */
    public function getActualSessionForIndex($indexSymbol)
    {
        $QueryBuilder = $this->createQueryBuilder('s');
        $QueryBuilder
            ->leftJoin('s.index','i')
            ->select('s,MAX(s.date) as maxDate','i')
            ->where($QueryBuilder->expr()->like('i.symbol', $QueryBuilder->expr()->literal($indexSymbol)))
            ->groupBy('i.id')
            ->having('maxDate = s.date')
        ;



        return $QueryBuilder->getQuery()->getOneOrNullResult()[0];
    }


    public function getLastTwoSessionsForIndexId($indexId)
    {
        $QueryBuilder = $this->createQueryBuilder('s');
        $QueryBuilder
            ->select('s')
            ->where($QueryBuilder->expr()->eq('s.indexId',$indexId))
            ->orderBy('s.date','DESC')
            ->setMaxResults(2);

        return $QueryBuilder->getQuery()->getResult();
        
    }

}
